/*
 * Decompiled with CFR 0.152.
 */
package com.dodgeman.shw.client.commands;

import com.dodgeman.shw.saveddata.models.WaypointName;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CommandLineFormatter {
    public static final ChatFormatting WAYPOINT_COLOR = ChatFormatting.LIGHT_PURPLE;
    public static final ChatFormatting COMMAND_COLOR = ChatFormatting.GRAY;

    public static MutableComponent formatWaypoint(WaypointName waypointName) {
        return Component.m_237113_((String)((String)waypointName.value())).m_130940_(WAYPOINT_COLOR);
    }

    public static MutableComponent formatWaypointItalic(WaypointName waypointName) {
        return Component.m_237113_((String)((String)waypointName.value())).m_130940_(WAYPOINT_COLOR).m_130940_(ChatFormatting.ITALIC);
    }

    public static MutableComponent formatCommand(String ... command) {
        return Component.m_237113_((String)("/" + String.join((CharSequence)" ", command))).m_130940_(COMMAND_COLOR).m_130940_(ChatFormatting.ITALIC);
    }

    public static MutableComponent formatNbOfWaypoints(int numberOfWaypoints, int maximumNumberOfWaypoints) {
        return Component.m_237113_((String)String.format("(%d/%d)", numberOfWaypoints, maximumNumberOfWaypoints)).m_130940_(CommandLineFormatter.getInfoSizeColorByNbOfWaypoints(numberOfWaypoints, maximumNumberOfWaypoints));
    }

    private static ChatFormatting getInfoSizeColorByNbOfWaypoints(int nbOfWaypoints, int maxNbOfWaypoints) {
        if (nbOfWaypoints >= maxNbOfWaypoints) {
            return ChatFormatting.RED;
        }
        if (nbOfWaypoints > maxNbOfWaypoints / 2) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    public static MutableComponent formatPermitted(boolean isPermitted) {
        return isPermitted ? Component.m_237115_((String)"shw.commands.config.permitted").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237115_((String)"shw.commands.config.not_permitted").m_130940_(ChatFormatting.RED);
    }
}

